class SpaceMathMission {
    constructor() {
        this.shield = 100;
        this.timeLeft = 30;
        this.difficulty = 1;
        this.currentProblem = null;
        
        this.elements = {
            problem: document.getElementById('multiplication-problem'),
            userAnswer: document.getElementById('user-answer'),
            submitButton: document.getElementById('submit-answer'),
            startButton: document.getElementById('start-game'),
            shieldDisplay: document.getElementById('score'),
            timerDisplay: document.getElementById('timer'),
            feedback: document.getElementById('mission-feedback'),
            difficultyButton: document.getElementById('difficulty-select')
        };

        this.setupEventListeners();
        this.createStarField();
    }

    createStarField() {
        const background = document.getElementById('starry-background');
        for (let i = 0; i < 100; i++) {
            const star = document.createElement('div');
            star.classList.add('star');
            star.style.left = `${Math.random() * 100}%`;
            star.style.top = `${Math.random() * 100}%`;
            star.style.animationDelay = `${Math.random() * 3}s`;
            background.appendChild(star);
        }
    }

    setupEventListeners() {
        this.elements.startButton.addEventListener('click', () => this.startMission());
        this.elements.submitButton.addEventListener('click', () => this.calculateRoute());
        this.elements.difficultyButton.addEventListener('click', () => this.adjustDifficulty());
    }

    generateNavigationProblem() {
        const num1 = this.getRandomNumber();
        const num2 = this.getRandomNumber();
        const answer = num1 - num2;
        
        this.currentProblem = {
            num1,
            num2,
            answer
        };

        this.elements.problem.textContent = `🚀 Calcula la ruta: (${num1}) - (${num2}) = ?`;
    }

    getRandomNumber() {
        return Math.floor(Math.random() * 25) - 12;
    }

    calculateRoute() {
        const userAnswer = parseInt(this.elements.userAnswer.value);
        
        if (userAnswer === this.currentProblem.answer) {
            this.shield += 10;
            this.shield = Math.min(this.shield, 100);
            this.elements.shieldDisplay.textContent = `${this.shield}%`;
            this.elements.feedback.textContent = '¡Ruta calculada con éxito! 🌟';
            this.elements.feedback.style.color = '#5cb4ff';
        } else {
            this.shield -= 15;
            this.elements.shieldDisplay.textContent = `${this.shield}%`;
            this.elements.feedback.textContent = `Error de navegación. Respuesta correcta: ${this.currentProblem.answer} ☄️`;
            this.elements.feedback.style.color = 'red';
        }

        this.elements.userAnswer.value = '';
        this.generateNavigationProblem();

        if (this.shield <= 0) {
            this.endMission();
        }
    }

    startTimer() {
        const timerInterval = setInterval(() => {
            this.timeLeft--;
            this.elements.timerDisplay.textContent = this.timeLeft;

            if (this.timeLeft <= 0) {
                clearInterval(timerInterval);
                this.endMission();
            }
        }, 1000);
    }

    startMission() {
        this.shield = 100;
        this.timeLeft = 30;
        this.elements.shieldDisplay.textContent = '100%';
        this.elements.timerDisplay.textContent = '30';
        this.elements.feedback.textContent = '¡Misión comenzada! 🚀';
        this.elements.submitButton.disabled = false;
        
        this.generateNavigationProblem();
        this.startTimer();
    }

    endMission() {
        this.elements.problem.innerHTML = `🏁 Misión Terminada<br>Escudo Final: ${this.shield}%`;
        this.elements.submitButton.disabled = true;
    }

    adjustDifficulty() {
        this.difficulty = this.difficulty === 3 ? 1 : this.difficulty + 1;
        const difficultyNames = ['Nivel Novato', 'Nivel Cadete', 'Nivel Astronauta'];
        this.elements.difficultyButton.textContent = difficultyNames[this.difficulty - 1];
    }
}

const mission = new SpaceMathMission();